﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Reflection;

namespace GeneratorWerIntKodu 
{

   /// <summary>
   /// Ze względu na to, że klasa Assembly nie posiada metody Unload, a musimy zwolnić podzespół na którym pracujemy, potrzebujemy
   /// załadować go przy pomocy AppDomain i osobnej klasy pomocniczej AssemblyLoader
   /// </summary>
   [Serializable]
   public class AssemblyLoader : MarshalByRefObject 
   {
      public string ObliczMd5DlaMetody()
      {
         Assembly _assembly = Assembly.Load("WeryfikacjaIntegralnosciKodu, Version=1.0.0.0, Culture=neutral");

         WsparcieMD5 md5Obiekt = new WsparcieMD5();
         return md5Obiekt.MD5Metody(_assembly.GetType("WeryfikacjaIntegralnosciKodu.MainForm").GetMethod("Komunikat"));
      }
   }

    class Program
    {
       static private string DodajZera(string zawartość)
       {
          string ret = "";
          for (int i = 0; i < zawartość.Length; i++)
             ret += zawartość[i] + "\0";
          return ret;
       }


        /// <summary>
        /// Główna funkcja programu podmieniająca wzorzec
        /// </summary>
        /// <param name="aPath"></param>
        static void ZmieńPlik(string aŚcieżka)
        {          
           // ładujemy podzespół poprzez AppDomain ponieważ inaczej nie dałoby się go rozładować, klasa Assembly nie ma metody Unload
           AppDomain domain = AppDomain.CreateDomain("appDomain");
           AssemblyLoader loader = (AssemblyLoader)domain.CreateInstanceAndUnwrap("GeneratorWerIntKodu, Version=1.0.0.0, Culture=neutral", "GeneratorWerIntKodu.AssemblyLoader");			
			  string md5 = loader.ObliczMd5DlaMetody();

			  AppDomain.Unload(domain);

           // odczyt pliku
           TextReader reader = new StreamReader(aŚcieżka, System.Text.Encoding.Default);
           string zawartośćPliku = reader.ReadToEnd();
           reader.Close();

           // modyfikacja zawartości
           int indeksPocz = zawartośćPliku.IndexOf(WsparcieMD5.wzorzecBinPoczątek);
           int indeksKon = zawartośćPliku.IndexOf(WsparcieMD5.wzorzecBinKoniec);
           if(indeksPocz != -1 && indeksKon != -1)
              zawartośćPliku = zawartośćPliku.Substring(0, indeksPocz + WsparcieMD5.wzorzecBinPoczątek.Length) +
                DodajZera(md5) + zawartośćPliku.Substring(indeksKon);
            
           // zapis pliku
           TextWriter writer = new StreamWriter(aŚcieżka, false, System.Text.Encoding.Default);
           writer.Write(zawartośćPliku);
           writer.Close();

           Console.WriteLine(aŚcieżka + " został zmodyfikowany " );
        }


        static void Main(string[] args)
        {
            if(args.Length < 1) 
                Console.WriteLine("Uruchom program z parametrem określającym modyfikowany plik.");
            else if(!File.Exists(args[0]))
                Console.WriteLine("Podany plik nie istnieje.");
            else ZmieńPlik(args[0]);
        }
    }
}
